/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.description.TypeDescription;
import org.assertj.assertions.generator.description.TypeName;
import org.assertj.assertions.generator.util.ClassUtil;
import org.assertj.assertions.generator.util.StringUtil;

public abstract class DataDescription {
    protected final String name;
    protected final String originalMember;
    protected final TypeDescription typeDescription;
    public static final Map<String, String> PREDICATE_PREFIXES_FOR_JAVADOC = new ImmutableMap.Builder().put((Object)"is", (Object)"is").put((Object)"isNot", (Object)"is not").put((Object)"was", (Object)"was").put((Object)"wasNot", (Object)"was not").put((Object)"can", (Object)"can").put((Object)"cannot", (Object)"cannot").put((Object)"should", (Object)"should").put((Object)"shouldNot", (Object)"should not").put((Object)"has", (Object)"has").put((Object)"doesNotHave", (Object)"does not have").put((Object)"will", (Object)"will").put((Object)"willNot", (Object)"will not").build();
    public static final Map<String, String> PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART1 = new ImmutableMap.Builder().put((Object)"is", (Object)"is").put((Object)"isNot", (Object)"is not").put((Object)"was", (Object)"was").put((Object)"wasNot", (Object)"was not").put((Object)"can", (Object)"can").put((Object)"cannot", (Object)"cannot").put((Object)"should", (Object)"should").put((Object)"shouldNot", (Object)"should not").put((Object)"has", (Object)"has").put((Object)"doesNotHave", (Object)"does not have").put((Object)"will", (Object)"will").put((Object)"willNot", (Object)"will not").build();
    public static final Map<String, String> PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART2 = new ImmutableMap.Builder().put((Object)"is", (Object)"is not").put((Object)"isNot", (Object)"is").put((Object)"was", (Object)"was not").put((Object)"wasNot", (Object)"was").put((Object)"can", (Object)"cannot").put((Object)"cannot", (Object)"can").put((Object)"should", (Object)"should not").put((Object)"shouldNot", (Object)"should").put((Object)"has", (Object)"does not have").put((Object)"doesNotHave", (Object)"has").put((Object)"will", (Object)"will not").put((Object)"willNot", (Object)"will").build();
    private static final Ordering<String> BY_BIGGER_LENGTH_ORDERING = new Ordering<String>(){

        public int compare(String left, String right) {
            return -Ints.compare((int)left.length(), (int)right.length());
        }
    };

    public DataDescription(String name, String originalMember, TypeDescription typeDescription) {
        this.name = name;
        this.originalMember = originalMember;
        this.typeDescription = typeDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalMember() {
        return this.originalMember;
    }

    public TypeDescription getTypeDescription() {
        return this.typeDescription;
    }

    public String getTypeName() {
        return this.typeDescription.getSimpleNameWithOuterClass();
    }

    public boolean isIterableType() {
        return this.typeDescription.isIterable();
    }

    public boolean isArrayType() {
        return this.typeDescription.isArray();
    }

    public boolean isPrimitiveType() {
        return this.typeDescription.isPrimitive();
    }

    public boolean isRealNumberType() {
        return this.typeDescription.isRealNumber();
    }

    public boolean isWholeNumberType() {
        return this.typeDescription.isWholeNumber();
    }

    public boolean isCharType() {
        return this.typeDescription.isChar();
    }

    public boolean isPrimitiveWrapperType() {
        return this.typeDescription.isPrimitiveWrapper();
    }

    public abstract boolean isPredicate();

    public String getPredicate() {
        return this.originalMember;
    }

    public String getNegativePredicate() {
        return ClassUtil.getNegativePredicateFor(this.originalMember);
    }

    public String getElementTypeName(String packageName) {
        return this.typeDescription.getElementTypeName() == null ? null : this.typeDescription.getElementTypeName().getFullyQualifiedTypeNameIfNeeded(packageName);
    }

    public String getElementAssertTypeName(String packageName) {
        TypeName elementTypeName = this.typeDescription.getElementTypeName();
        return elementTypeName == null ? null : elementTypeName.getAssertTypeName(packageName);
    }

    public String getFullyQualifiedTypeNameIfNeeded(String packageName) {
        return this.typeDescription.getFullyQualifiedTypeNameIfNeeded(packageName);
    }

    public String getAssertTypeName(String packageName) {
        return this.typeDescription.getAssertTypeName(packageName);
    }

    public String getPredicateForJavadoc() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getPredicate());
        return PREDICATE_PREFIXES_FOR_JAVADOC.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getNegativePredicateForJavadoc() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getNegativePredicate());
        return PREDICATE_PREFIXES_FOR_JAVADOC.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getPredicateForErrorMessagePart1() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getPredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART1.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getPredicateForErrorMessagePart2() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getPredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART2.get(predicatePrefix);
    }

    public String getNegativePredicateForErrorMessagePart1() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getNegativePredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART1.get(predicatePrefix) + " " + this.readablePropertyName();
    }

    public String getNegativePredicateForErrorMessagePart2() {
        String predicatePrefix = ClassUtil.getPredicatePrefix(this.getNegativePredicate());
        return PREDICATE_PREFIXES_FOR_ERROR_MESSAGE_PART2.get(predicatePrefix);
    }

    protected String readablePropertyName() {
        ImmutableList prefixesSortedByBiggerLength = BY_BIGGER_LENGTH_ORDERING.immutableSortedCopy(PREDICATE_PREFIXES_FOR_JAVADOC.keySet());
        for (String predicatePrefix : prefixesSortedByBiggerLength) {
            if (!this.originalMember.startsWith(predicatePrefix)) continue;
            String propertyName = StringUtils.removeStart((String)this.originalMember, (String)predicatePrefix);
            return StringUtil.camelCaseToWords(propertyName);
        }
        return this.name;
    }
}

