/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class ClassUtil {
    public static final String IS_PREFIX = "is";
    public static final String GET_PREFIX = "get";
    private static final String CLASS_SUFFIX = ".class";
    private static final Comparator<Method> GETTER_COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method m1, Method m2) {
            return m1.getName().compareTo(m2.getName());
        }
    };
    private static final Pattern PREFIX_PATTERN;
    private static final Map<String, String> PREDICATE_PREFIXES;
    private static final Comparator<String> LONGEST_TO_SHORTEST;

    public static Set<Class<?>> collectClasses(String ... classOrPackageNames) {
        return ClassUtil.collectClasses(Thread.currentThread().getContextClassLoader(), classOrPackageNames);
    }

    public static Set<Class<?>> collectClasses(ClassLoader classLoader, String ... classOrPackageNames) {
        LinkedHashSet classes = Sets.newLinkedHashSet();
        for (String classOrPackageName : classOrPackageNames) {
            Class<?> clazz = ClassUtil.tryToLoadClass(classOrPackageName, classLoader);
            if (clazz != null) {
                classes.add(clazz);
                continue;
            }
            classes.addAll(ClassUtil.getClassesInPackage(classOrPackageName, classLoader));
        }
        return classes;
    }

    private static Set<Class<?>> getClassesInPackage(String packageName, ClassLoader classLoader) {
        if (classLoader == null) {
            throw new IllegalArgumentException("Null class loader.");
        }
        Set<Class<?>> packageClasses = ClassUtil.getPackageClassesFromClasspathFiles(packageName, classLoader);
        try {
            packageClasses.addAll(ClassUtil.getPackageClassesFromClasspathJars(packageName, classLoader));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packageClasses;
    }

    private static Set<Class<?>> getPackageClassesFromClasspathJars(String packageName, ClassLoader classLoader) throws IOException {
        ImmutableSet classesInfo = ClassPath.from((ClassLoader)classLoader).getTopLevelClassesRecursive(packageName);
        HashSet<Class> classesInPackage = new HashSet<Class>();
        for (ClassPath.ClassInfo classInfo : classesInfo) {
            classesInPackage.add(classInfo.load());
        }
        HashSet filteredClassesInPackage = new HashSet();
        for (Class classFromJar : classesInPackage) {
            if (!ClassUtil.isClassCandidateToAssertionsGeneration(classFromJar)) continue;
            filteredClassesInPackage.add(classFromJar);
        }
        return filteredClassesInPackage;
    }

    private static Set<Class<?>> getPackageClassesFromClasspathFiles(String packageName, ClassLoader classLoader) {
        try {
            String packagePath = packageName.replace('.', File.separatorChar);
            Enumeration<URL> resources = classLoader.getResources(packagePath);
            LinkedHashSet classes = Sets.newLinkedHashSet();
            while (resources.hasMoreElements()) {
                File directory = new File(URLDecoder.decode(resources.nextElement().getPath(), "UTF-8"));
                if (!directory.canRead()) continue;
                classes.addAll(ClassUtil.getClassesInDirectory(directory, packageName, classLoader));
            }
            return classes;
        }
        catch (UnsupportedEncodingException encex) {
            throw new RuntimeException(packageName + " does not appear to be a valid package (Unsupported encoding)", encex);
        }
        catch (IOException ioex) {
            throw new RuntimeException("IOException was thrown when trying to get all classes for " + packageName, ioex);
        }
    }

    private static Set<Class<?>> getClassesInDirectory(File directory, String packageName, ClassLoader classLoader) throws UnsupportedEncodingException {
        File[] files;
        LinkedHashSet classes = Sets.newLinkedHashSet();
        for (File currentFile : files = directory.listFiles()) {
            String currentFileName = currentFile.getName();
            if (ClassUtil.isClass(currentFileName)) {
                try {
                    String className = packageName + '.' + StringUtils.remove((String)currentFileName, (String)CLASS_SUFFIX);
                    Class<?> loadedClass = ClassUtil.loadClass(className, classLoader);
                    if (!ClassUtil.isClassCandidateToAssertionsGeneration(loadedClass)) continue;
                    classes.add(loadedClass);
                }
                catch (Throwable className) {}
                continue;
            }
            if (!currentFile.isDirectory()) continue;
            String subPackageName = packageName + ClassUtils.PACKAGE_SEPARATOR + currentFileName;
            URL resource = classLoader.getResource(subPackageName.replace('.', File.separatorChar));
            File subDirectory = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
            Set<Class<?>> classesForSubPackage = ClassUtil.getClassesInDirectory(subDirectory, subPackageName, classLoader);
            classes.addAll(classesForSubPackage);
        }
        return classes;
    }

    private static boolean isClassCandidateToAssertionsGeneration(Class<?> loadedClass) {
        return loadedClass != null && Modifier.isPublic(loadedClass.getModifiers()) && !loadedClass.isAnonymousClass() && !loadedClass.isLocalClass();
    }

    private static boolean isClass(String fileName) {
        return fileName.endsWith(CLASS_SUFFIX);
    }

    private static Class<?> tryToLoadClass(String className, ClassLoader classLoader) {
        try {
            return ClassUtil.loadClass(className, classLoader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class<?> loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(className, false, classLoader);
    }

    public static String propertyNameOf(Method getter) {
        String prefixToRemove;
        String methodName = getter.getName();
        int pos = methodName.indexOf(prefixToRemove = ClassUtil.isPredicate(getter) ? IS_PREFIX : GET_PREFIX);
        if (pos != -1) {
            String propertyWithCapitalLetter = methodName.substring(pos + prefixToRemove.length());
            return StringUtils.uncapitalize((String)propertyWithCapitalLetter);
        }
        return methodName;
    }

    public static boolean inheritsCollectionOrIsIterable(Class<?> returnType) {
        return Collection.class.isAssignableFrom(returnType) || Iterable.class.equals(returnType);
    }

    public static boolean isArray(Class<?> returnType) {
        return returnType.isArray();
    }

    public static boolean isStandardGetter(Method method) {
        return ClassUtil.isValidStandardGetterName(method.getName()) && !Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0;
    }

    public static boolean isPredicate(Method method) {
        return ClassUtil.isValidPredicateName(method.getName()) && (Boolean.TYPE.equals(method.getReturnType()) || Boolean.class.equals(method.getReturnType())) && method.getParameterTypes().length == 0;
    }

    private static boolean isAnnotated(Method method, Set<Class<?>> includeAnnotations, boolean isClassAnnotated) {
        if (!Void.TYPE.equals(method.getReturnType()) && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers())) {
            Annotation[] methodAnnotations = method.getAnnotations();
            return isClassAnnotated || ClassUtil.containsAny(methodAnnotations, includeAnnotations);
        }
        return false;
    }

    private static boolean containsAny(Annotation[] methodAnnotations, Set<Class<?>> includeAnnotations) {
        for (Annotation annotation : methodAnnotations) {
            if (!includeAnnotations.contains(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidGetterName(String methodName) {
        return PREFIX_PATTERN.matcher(methodName).find();
    }

    private static boolean isValidStandardGetterName(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        return m.find() && m.group().equals(GET_PREFIX);
    }

    public static String getPredicatePrefix(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        return m.find() ? m.group() : null;
    }

    public static boolean isValidPredicateName(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        return m.find() && PREDICATE_PREFIXES.containsKey(m.group());
    }

    public static String getNegativePredicateFor(String name) {
        Matcher m = PREFIX_PATTERN.matcher(name);
        if (m.find()) {
            return m.replaceFirst(PREDICATE_PREFIXES.get(m.group()));
        }
        return null;
    }

    public static Set<Method> declaredGetterMethodsOf(Class<?> clazz, Set<Class<?>> includeAnnotations) {
        boolean isClassAnnotated = ClassUtil.containsAny(clazz.getDeclaredAnnotations(), includeAnnotations);
        return ClassUtil.filterGetterMethods(clazz.getDeclaredMethods(), includeAnnotations, isClassAnnotated);
    }

    public static Set<Method> getterMethodsOf(Class<?> clazz, Set<Class<?>> includeAnnotations) {
        boolean isClassAnnotated = ClassUtil.containsAny(clazz.getDeclaredAnnotations(), includeAnnotations);
        return ClassUtil.filterGetterMethods(clazz.getMethods(), includeAnnotations, isClassAnnotated);
    }

    private static Set<Method> filterGetterMethods(Method[] methods, Set<Class<?>> includeAnnotations, boolean isClassAnnotated) {
        TreeSet<Method> getters = new TreeSet<Method>(GETTER_COMPARATOR);
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Modifier.isPublic(method.getModifiers()) || !ClassUtil.isNotDefinedInObjectClass(method) || !ClassUtil.isGetter(method, includeAnnotations, isClassAnnotated)) continue;
            getters.add(method);
        }
        return getters;
    }

    private static boolean isGetter(Method method, Set<Class<?>> includeAnnotations, boolean isClassAnnotated) {
        return ClassUtil.isStandardGetter(method) || ClassUtil.isPredicate(method) || ClassUtil.isAnnotated(method, includeAnnotations, isClassAnnotated);
    }

    public static List<Field> nonStaticPublicFieldsOf(Class<?> clazz) {
        Field[] fields = clazz.getFields();
        ArrayList<Field> nonStaticPublicFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!ClassUtil.isNotStaticPublicField(field)) continue;
            nonStaticPublicFields.add(field);
        }
        return nonStaticPublicFields;
    }

    public static List<Field> declaredPublicFieldsOf(Class<?> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> nonStaticPublicFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (!ClassUtil.isNotStaticPublicField(field)) continue;
            nonStaticPublicFields.add(field);
        }
        return nonStaticPublicFields;
    }

    private static boolean isNotStaticPublicField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers);
    }

    private static boolean isNotDefinedInObjectClass(Method method) {
        return !method.getDeclaringClass().equals(Object.class);
    }

    public static Set<Class<?>> getClassesRelatedTo(Type type) {
        HashSet classes = new HashSet();
        if (type instanceof Class) {
            classes.add((Class)type);
            return classes;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof ParameterizedType) {
                    classes.addAll(ClassUtil.getClassesRelatedTo(actualTypeArgument));
                    continue;
                }
                if (actualTypeArgument instanceof Class) {
                    classes.add((Class)actualTypeArgument);
                    continue;
                }
                if (!(actualTypeArgument instanceof GenericArrayType)) continue;
                classes.addAll(ClassUtil.getClassesRelatedTo(actualTypeArgument));
            }
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                classes.add((Class)rawType);
            }
        }
        return classes;
    }

    public static String getSimpleNameWithOuterClass(Class<?> clazz) {
        if (ClassUtil.isNotNestedClass(clazz)) {
            return clazz.getSimpleName();
        }
        String nestedClassName = null;
        nestedClassName = clazz.getName();
        nestedClassName = nestedClassName.substring(clazz.getPackage().getName().length() + 1);
        nestedClassName = nestedClassName.replace('$', '.');
        return nestedClassName;
    }

    public static String getSimpleNameWithOuterClassNotSeparatedByDots(Class<?> clazz) {
        if (ClassUtil.isNotNestedClass(clazz)) {
            return clazz.getSimpleName();
        }
        String nestedClassName = null;
        nestedClassName = clazz.getName();
        nestedClassName = nestedClassName.substring(clazz.getPackage().getName().length() + 1);
        nestedClassName = StringUtils.remove((String)nestedClassName, (char)'$');
        return nestedClassName;
    }

    private static boolean isNotNestedClass(Class<?> clazz) {
        return clazz.getDeclaringClass() == null;
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ClassUtil.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = ClassUtil.getClass(componentType);
            return componentClass == null ? null : Array.newInstance(componentClass, 0).getClass();
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return wildcardType.getUpperBounds() != null ? ClassUtil.getClass(wildcardType.getUpperBounds()[0]) : (wildcardType.getLowerBounds() != null ? ClassUtil.getClass(wildcardType.getLowerBounds()[0]) : null);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type[] bounds = typeVariable.getBounds();
            return bounds.length > 0 ? ClassUtil.getClass(bounds[0]) : Object.class;
        }
        return null;
    }

    static {
        LONGEST_TO_SHORTEST = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int lengthComp = o2.length() - o1.length();
                return lengthComp == 0 ? o1.compareTo(o2) : lengthComp;
            }
        };
        String[][] predicates = new String[][]{{IS_PREFIX, "isNot"}, {"was", "wasNot"}, {"can", "cannot"}, {"should", "shouldNot"}, {"has", "doesNotHave"}, {"will", "willNot"}};
        StringBuilder pattern = new StringBuilder("^(?:get");
        HashMap<String, String> map = new HashMap<String, String>();
        for (String[] pair : predicates) {
            map.put(pair[0], pair[1]);
            map.put(pair[1], pair[0]);
        }
        TreeSet<String> sort = new TreeSet<String>(LONGEST_TO_SHORTEST);
        sort.addAll(map.keySet());
        for (String prefix : sort) {
            pattern.append('|').append(prefix);
        }
        pattern.append(")(?=\\p{Upper})");
        PREFIX_PATTERN = Pattern.compile(pattern.toString());
        PREDICATE_PREFIXES = Collections.unmodifiableMap(map);
    }
}

