/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.cli;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.assertj.assertions.generator.BaseAssertionGenerator;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.converter.ClassToClassDescriptionConverter;
import org.assertj.assertions.generator.util.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertionGeneratorLauncher {
    private static final Logger logger = LoggerFactory.getLogger(AssertionGeneratorLauncher.class);
    private static ClassToClassDescriptionConverter classDescriptionConverter = new ClassToClassDescriptionConverter();

    public static void main(String[] args) throws IOException {
        Options options = new Options();
        options.addOption("H", "hierarchical", false, "Generate a hierarchy of assertions that follows the hierarchy of classes to assert");
        options.addOption("h", "help", false, "Print this help message");
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption('h')) {
                AssertionGeneratorLauncher.printHelp(options);
                return;
            }
            Set<Class<?>> classes = ClassUtil.collectClasses(line.getArgs());
            if (line.hasOption('H')) {
                AssertionGeneratorLauncher.generateHierarchicalAssertions(classes);
            } else {
                AssertionGeneratorLauncher.generateFlatAssertions(classes);
            }
        }
        catch (ParseException e) {
            System.err.println("Error trying to parse command-line arguments: " + e.getMessage());
            AssertionGeneratorLauncher.printHelp(options);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        String cmdLine = "java " + AssertionGeneratorLauncher.class.getCanonicalName() + " [--help] [--hierarchical] <classes/packages>";
        help.printHelp(cmdLine, "Generate AssertJ-style assertions for the specified classes", options, "The list of classes can either be package names (which includes all packages in the class) or fully-qualified class names.");
    }

    private static void generateHierarchicalAssertions(Set<Class<?>> classes) throws IOException {
        LinkedHashSet classSet = Sets.newLinkedHashSet(classes);
        logger.info("Generating hierarchical assertions for classes {}", classes);
        BaseAssertionGenerator customAssertionGenerator = new BaseAssertionGenerator();
        for (Class<?> clazz : classes) {
            logger.info("Generating hierarchical assertions for class : {}", (Object)clazz.getName());
            File[] customAssertionFiles = customAssertionGenerator.generateHierarchicalCustomAssertionFor(AssertionGeneratorLauncher.toClassDescription(clazz), classSet);
            logger.info("Generated {} hierarchical assertions files -> {}, {}", new Object[]{clazz.getSimpleName(), customAssertionFiles[0].getAbsolutePath(), customAssertionFiles[1].getAbsolutePath()});
        }
    }

    private static void generateFlatAssertions(Set<Class<?>> classes) throws IOException {
        logger.info("Generating assertions for classes {}", classes);
        BaseAssertionGenerator customAssertionGenerator = new BaseAssertionGenerator();
        for (Class<?> clazz : classes) {
            logger.info("Generating assertions for class : {}", (Object)clazz.getName());
            File customAssertionFile = customAssertionGenerator.generateCustomAssertionFor(AssertionGeneratorLauncher.toClassDescription(clazz));
            logger.info("Generated {} assertions file -> {}", (Object)clazz.getSimpleName(), (Object)customAssertionFile.getAbsolutePath());
        }
    }

    private static ClassDescription toClassDescription(Class<?> clazz) {
        return classDescriptionConverter.convertToClassDescription(clazz);
    }
}

