/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import org.assertj.assertions.generator.description.TypeName;

public class TypeDescription {
    private TypeName typeName;
    private boolean isArray;
    private boolean isIterable;
    private TypeName elementTypeName;

    public TypeDescription(TypeName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName must not be null.");
        }
        this.typeName = typeName;
        this.isArray = false;
        this.isIterable = false;
        this.elementTypeName = null;
    }

    public String getSimpleNameWithOuterClass() {
        return this.typeName.getSimpleNameWithOuterClass();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public boolean isPrimitive() {
        return this.typeName.isPrimitive();
    }

    public boolean isRealNumber() {
        return this.typeName.isRealNumber();
    }

    public boolean isWholeNumber() {
        return this.typeName.isWholeNumber();
    }

    public boolean isBoolean() {
        return this.typeName.isBoolean();
    }

    public boolean isChar() {
        return this.typeName.isChar();
    }

    public boolean isPrimitiveWrapper() {
        return this.typeName.isPrimitiveWrapper();
    }

    public TypeName getElementTypeName() {
        return this.elementTypeName;
    }

    public void setElementTypeName(TypeName elementTypeName) {
        this.elementTypeName = elementTypeName;
    }

    public boolean isIterable() {
        return this.isIterable;
    }

    public void setIterable(boolean isIterable) {
        this.isIterable = isIterable;
    }

    public String toString() {
        return "TypeDescription[typeName=" + this.typeName + ", array=" + this.isArray + ", iterable=" + this.isIterable + ", primitive=" + this.isPrimitive() + ", boolean=" + this.isBoolean() + ", elementTypeName=" + this.elementTypeName + "]";
    }

    public String getFullyQualifiedTypeNameIfNeeded(String packageName) {
        return this.typeName.getFullyQualifiedTypeNameIfNeeded(packageName);
    }

    public String getAssertTypeName(String packageName) {
        if (this.typeName == null) {
            return null;
        }
        return this.typeName.getAssertTypeName(packageName);
    }
}

