/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import java.util.ArrayList;
import java.util.List;
import org.assertj.assertions.generator.description.DataDescription;
import org.assertj.assertions.generator.description.TypeDescription;
import org.assertj.assertions.generator.description.TypeName;
import org.assertj.assertions.generator.util.ClassUtil;

public class GetterDescription
extends DataDescription
implements Comparable<GetterDescription> {
    private final List<TypeName> exceptions;

    public GetterDescription(String propertyName, String origMethodName, TypeDescription typeDescription, List<TypeName> exceptions) {
        super(propertyName, origMethodName, typeDescription);
        this.exceptions = new ArrayList<TypeName>(exceptions);
    }

    public String getPropertyName() {
        return this.getName();
    }

    @Override
    public int compareTo(GetterDescription other) {
        return this.getOriginalMember().compareTo(other.getOriginalMember());
    }

    public String toString() {
        return "GetterDescription [propertyName=" + this.getName() + ", typeDescription=" + this.typeDescription + "]";
    }

    public List<TypeName> getExceptions() {
        return this.exceptions;
    }

    @Override
    public boolean isPredicate() {
        return this.typeDescription.isBoolean() && ClassUtil.isValidPredicateName(this.originalMember);
    }
}

