/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description.converter;

import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.GenerateAssertion;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.description.TypeDescription;
import org.assertj.assertions.generator.description.TypeName;
import org.assertj.assertions.generator.description.converter.AnnotationConfiguration;
import org.assertj.assertions.generator.description.converter.ClassDescriptionConverter;
import org.assertj.assertions.generator.util.ClassUtil;

public class ClassToClassDescriptionConverter
implements ClassDescriptionConverter<Class<?>> {
    private final AnnotationConfiguration annotationConfiguration;

    public ClassToClassDescriptionConverter() {
        this(new AnnotationConfiguration(GenerateAssertion.class));
    }

    public ClassToClassDescriptionConverter(AnnotationConfiguration annotationConfiguration) {
        this.annotationConfiguration = annotationConfiguration;
    }

    @Override
    public ClassDescription convertToClassDescription(Class<?> clazz) {
        ClassDescription classDescription = new ClassDescription(new TypeName(clazz));
        classDescription.addGetterDescriptions(this.getterDescriptionsOf(clazz));
        classDescription.addFieldDescriptions(this.fieldDescriptionsOf(clazz));
        classDescription.addDeclaredGetterDescriptions(this.declaredGetterDescriptionsOf(clazz));
        classDescription.addDeclaredFieldDescriptions(this.declaredFieldDescriptionsOf(clazz));
        classDescription.setSuperType(clazz.getSuperclass());
        return classDescription;
    }

    private Set<GetterDescription> getterDescriptionsOf(Class<?> clazz) {
        return this.doGetterDescriptionsOf(ClassUtil.getterMethodsOf(clazz, this.annotationConfiguration.includedAnnotations()), clazz);
    }

    private Set<GetterDescription> declaredGetterDescriptionsOf(Class<?> clazz) {
        return this.doGetterDescriptionsOf(ClassUtil.declaredGetterMethodsOf(clazz, this.annotationConfiguration.includedAnnotations()), clazz);
    }

    private Set<GetterDescription> doGetterDescriptionsOf(Set<Method> getters, Class<?> clazz) {
        TreeSet<GetterDescription> getterDescriptions = new TreeSet<GetterDescription>();
        for (Method getter : getters) {
            if (this.isGetDeclaringClassEnumGetter(getter, clazz)) continue;
            TypeDescription typeDescription = this.getTypeDescription(getter);
            List<TypeName> exceptionTypeNames = this.getExceptionTypeNames(getter);
            String propertyName = ClassUtil.propertyNameOf(getter);
            getterDescriptions.add(new GetterDescription(propertyName, getter.getName(), typeDescription, exceptionTypeNames));
        }
        return getterDescriptions;
    }

    private Set<FieldDescription> declaredFieldDescriptionsOf(Class<?> clazz) {
        return this.doFieldDescriptionsOf(ClassUtil.declaredPublicFieldsOf(clazz));
    }

    private Set<FieldDescription> fieldDescriptionsOf(Class<?> clazz) {
        return this.doFieldDescriptionsOf(ClassUtil.nonStaticPublicFieldsOf(clazz));
    }

    private Set<FieldDescription> doFieldDescriptionsOf(List<Field> fields) {
        TreeSet<FieldDescription> fieldDescriptions = new TreeSet<FieldDescription>();
        for (Field field : fields) {
            fieldDescriptions.add(new FieldDescription(field.getName(), this.getTypeDescription(field)));
        }
        return fieldDescriptions;
    }

    private boolean isGetDeclaringClassEnumGetter(Method getter, Class<?> clazz) {
        return clazz.isEnum() && getter.getName().equals("getDeclaringClass");
    }

    private List<TypeName> getExceptionTypeNames(Method getter) {
        ArrayList<TypeName> exceptions = new ArrayList<TypeName>();
        for (Class<?> exception : getter.getExceptionTypes()) {
            exceptions.add(new TypeName(exception));
        }
        return exceptions;
    }

    private TypeDescription getTypeDescription(Member member) {
        Class<?> type = ClassToClassDescriptionConverter.getTypeOf(member);
        if (ClassUtil.isArray(type)) {
            return ClassToClassDescriptionConverter.buildArrayTypeDescription(type);
        }
        if (ClassUtil.inheritsCollectionOrIsIterable(type)) {
            return this.buildIterableTypeDescription(member, type);
        }
        return new TypeDescription(new TypeName(type));
    }

    private TypeDescription buildIterableTypeDescription(Member member, Class<?> type) {
        TypeDescription typeDescription = new TypeDescription(new TypeName(type));
        typeDescription.setIterable(true);
        if (ClassToClassDescriptionConverter.methodReturnTypeHasNoParameterInfo(member)) {
            typeDescription.setElementTypeName(new TypeName(Object.class));
            return typeDescription;
        }
        ParameterizedType parameterizedType = ClassToClassDescriptionConverter.getParameterizedTypeOf(member);
        if (parameterizedType.getActualTypeArguments()[0] instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)parameterizedType.getActualTypeArguments()[0];
            typeDescription.setElementTypeName(new TypeName(genericArrayType.toString()));
            return typeDescription;
        }
        Class<?> internalClass = ClassUtil.getClass(parameterizedType.getActualTypeArguments()[0]);
        if (internalClass.isArray()) {
            String componentTypeWithoutClassPrefix = StringUtils.remove((String)internalClass.getComponentType().toString(), (String)"class ");
            typeDescription.setElementTypeName(new TypeName(componentTypeWithoutClassPrefix + "[]"));
        } else {
            typeDescription.setElementTypeName(new TypeName(internalClass));
        }
        return typeDescription;
    }

    private static boolean methodReturnTypeHasNoParameterInfo(Member member) {
        return member instanceof Method && !(((Method)member).getGenericReturnType() instanceof ParameterizedType);
    }

    private static Class<?> getTypeOf(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getReturnType();
        }
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        throw new IllegalArgumentException("argument should be a Method or Field but was " + member.getClass());
    }

    private static ParameterizedType getParameterizedTypeOf(Member member) {
        if (member instanceof Method) {
            return (ParameterizedType)((Method)member).getGenericReturnType();
        }
        if (member instanceof Field) {
            return (ParameterizedType)((Field)member).getGenericType();
        }
        throw new IllegalArgumentException("argument should be a Method or Field but was " + member.getClass());
    }

    private static TypeDescription buildArrayTypeDescription(Class<?> arrayType) {
        TypeDescription typeDescription = new TypeDescription(new TypeName(arrayType));
        typeDescription.setElementTypeName(new TypeName(arrayType.getComponentType()));
        typeDescription.setArray(true);
        return typeDescription;
    }
}

